
#include "../../messagebox.ped"

class App@Scope@SlotDump extends PepDisplayObject {

    public int DmpCycles;

    public string EditSynth;
    public int DmpSlotA;
    public int DmpSlotB;
    public int DmpSlotC;
    public int DmpSlotD;
    public int DmpAll;
    public int DmpMixer;
    public int DmpDelays;
    public int DmpEffects;

    string noahproject = "D:/Scope/projects/noahslots.pro";
    string noahslotpath;
    string noahpath = "d:/cream/noah/IF/";
    boolean deleteDev = true;
    
    string synths [] = {
            "MINIMAX",                "MINIMAX",       "  3  6 10 13", "  1 40 40 40",
            "LightWave",              "LightWave",     "  6 12 17 23", "  1 20 42 42",
            "Pro One",                "Pro One",       "  2  5  8 11", "  1 30 30 24",
            "SixString",              "SixString",     "  2  6  9 12", "  1 16 20 24",
            "B-2003",                 "B-2003",        " -1 -1 -1 -1", "  1 16 16 23",
            "Vectron P",              "Vectron P",     "  3  7 10 14", "  1 24 30 30", // 10 14
            "Vocodizer",              "Vocodizer",     " -1 -1 -1 -1", "  1 16 16 16",
            "Interpole",              "Interpole",     " -1 -1 -1 -1", "  1 16 16 16",
        };

    static {
        string path = SIni.GetString ("STATICPATH", "noah", "d:/cream/noah/");
        noahpath = path + "IF/";
        noahslotpath = path + "../NoahSlots/";
        noahproject = noahslotpath + "noahslots.pro";
    }

    public void CreateSlotDump (object Module, string fname_base, int voices, boolean createNdl)
    {
        //throw "stop!";
        
        int notLoadedModules, notConnectedRoutings;
        if (!SHardware.HalStatus (notLoadedModules, notConnectedRoutings) || notLoadedModules > 0 || notConnectedRoutings > 0)
            throw Module.Name () + " could not be loaded onto the hardware,\n modules and connections still cached";

        int slot = -1;
        if (!Module.GetAttribute ("SlotID", slot, true) || slot <= 0)
            throw "no slot ID set for selected module or ID 0";
        
        string config = SIni.GetString ("hw", "defconfig", "hw");
        string slotini = SIni.GetString (config, "slotconfigfile", "");
        string model   = SIni.GetString (config, "slotmodel", "");
        int slots = SIni.GetInt (model, "slots", 0, slotini);
        if (slot >= slots)
            throw fromat ("not so many slots (%d of %d) in model %s in file %s", slot, slots, model, slotini);
        
        string slotfmt = SIni.GetString (model, "slot%d", "slot%d", slotini);
        string slotname = format (slotfmt, slot);
        slotname = SIni.GetString (model, slotname, slotname, slotini);
        
        string slottype = SIni.GetString (slotname, "Type", "", slotini);
        int typeid = SIni.GetInt (slottype, "TypeID", -1, slotini);
        if (typeid == -1)
            throw "no typeid set for selected slot";

        string dsplib = fname_base + ".ndl";
        if (createNdl || !SFile.Exists (dsplib)) {
            TRACE ("writing " + dsplib); ForceGraphicUpdate ();

            if (!SSystem.DumpDSPSlotLib (dsplib, slot))
                throw "DumpDSPSlotLib (" + dsplib + ") failed";
        }
    
        string slotfile = fname_base + format (".S%02x", typeid);
        TRACE ("writing " + slotfile); ForceGraphicUpdate ();
        
        if (!SSystem.DumpDSPSlotConfig (slotfile, dsplib, slot, voices))
            throw "DumpDSPSlotConfig (" + slotfile + ") failed";

        int sync, async, dm, pm, sram, sdram;
        GetResources (Module, sync, async, dm, pm, sram, sdram);

        int ratio = 14;
        string txt = format ("voices=%d, sync %d, async %d = %.2f", voices, sync, async, (ratio * sync + async) / (double) ratio);
        txt = txt + format (", dm %d", dm);
        txt = txt + format (", pm %d", pm);
        txt = txt + format (", sram %d", sram);
        txt = txt + format (", sdram %d", sdram);
        TRACE (txt); ForceGraphicUpdate ();
    }
  
    void GetResources (object o, int sync, int async, int dm, int pm, int sram, int sdram)
    {
        if (o.IsKindOf ("PepAtom") != 0) {
            int _sync, _async, _dm, _pm, _sram, _sdram;
            if (o.Resources (_sync, _async, _dm, _pm, _sram, _sdram, true)) {
                sync  += _sync;
                async += _async;
                dm    += _dm;
                pm    += _pm;
                sram  += _sram;
                sdram += _sdram;
            }
        }

        for (int i = 0; i < o.ChildCount (); i++)
            GetResources (o.ChildByIndex (i), sync, async, dm, pm, sram, sdram);
    }        
    
    void ConnectIfExists (object pad1, object pad2)
    {
        if (pad1 != nil && pad2 != nil)
            pad1.ConnectVisible (pad2);
    }
  
    public void LoadnDump (object Parent, string fname, string outname_base, int voices, boolean createNdl)
    {
        object dev;
        object platform = SApp.HardwareConfigModule().HardwareWrapper();
        int ok = 0;
        try {
            RunStopDSP (false);
            dev = Parent.LoadChild (fname, true, true);
            if (dev == nil)
                throw "cannot load " + fname;
            if (platform != nil)
                platform.AdjustModule (dev);

            int SlotID = -1;
            Parent.GetAttribute ("SlotID", SlotID);
            
            if (SlotID == 5) {
                ConnectIfExists (Parent.ChildByName ("DummyMidiIn").PadByName ("MIDI"), dev.PadByName ("MIDI"));
                ConnectIfExists (Parent.ChildByName ("DummyMidiIn").PadByName ("MIDI"), dev.PadByName ("Midi"));
                ConnectIfExists (Parent.ChildByName ("ParallelBus MixSrc").PadByName ("DL1"), dev.PadByName ("in1"));
                ConnectIfExists (Parent.ChildByName ("ParallelBus MixSrc").PadByName ("DR1"), dev.PadByName ("in2"));
                ConnectIfExists (Parent.ChildByName ("ParallelBus MixSrc").PadByName ("DL2"), dev.PadByName ("in3"));
                ConnectIfExists (Parent.ChildByName ("ParallelBus MixSrc").PadByName ("DR2"), dev.PadByName ("in4"));
                ConnectIfExists (Parent.ChildByName ("ParallelBus MixSrc").PadByName ("DL3"), dev.PadByName ("in5"));
                ConnectIfExists (Parent.ChildByName ("ParallelBus MixSrc").PadByName ("DR3"), dev.PadByName ("in6"));
                ConnectIfExists (Parent.ChildByName ("ParallelBus MixSrc").PadByName ("DL4"), dev.PadByName ("in7"));
                ConnectIfExists (Parent.ChildByName ("ParallelBus MixSrc").PadByName ("DR4"), dev.PadByName ("in8"));
                ConnectIfExists (Parent.ChildByName ("ParallelBus MixSrc").PadByName ("DL5"), dev.PadByName ("in9"));
                ConnectIfExists (Parent.ChildByName ("ParallelBus MixSrc").PadByName ("DR5"), dev.PadByName ("in10"));
                ConnectIfExists (Parent.ChildByName ("ParallelBus MixSrc").PadByName ("DL6"), dev.PadByName ("in11"));
                ConnectIfExists (Parent.ChildByName ("ParallelBus MixSrc").PadByName ("DR6"), dev.PadByName ("in12"));
                
                Parent.ChildByName ("Parallel DeviceDest").PadByName ("In0").ConnectVisible (dev.PadByName ("OutL"));
                Parent.ChildByName ("Parallel DeviceDest").PadByName ("In1").ConnectVisible (dev.PadByName ("OutR"));
            } else {
                Parent.ChildByName ("MemoryBus Insert Src").PadByName ("Out0").ConnectVisible (dev.PadByName ("InL"));
                Parent.ChildByName ("MemoryBus Insert Src").PadByName ("Out1").ConnectVisible (dev.PadByName ("InR"));
                Parent.ChildByName ("MemoryBus Insert Dest").PadByName ("In0").ConnectVisible (dev.PadByName ("OutL"));
                Parent.ChildByName ("MemoryBus Insert Dest").PadByName ("In1").ConnectVisible (dev.PadByName ("OutR"));
            }
          
            if (voices != -1)
                dev.ParameterByName ("cwVoices").GetVar ().ValueCallSend (voices);

        } finally {
            RunStopDSP (true);
        }

        object progress = SApp.Progress ();
        if (progress != nil) {
           try {
              progress.ProgressStart ("Idle " + fname);
              for (double f = 0; f < 1.0; f += 0.05)
                 progress.ProgressSet (f);
           } finally {
              progress.ProgressEnd ();
           }
        }        
               
        // CheckDevice (dev, false);
              
        CreateSlotDump (dev, outname_base, voices, createNdl);
        if (deleteDev)
            DeleteObject (dev);
    }      

    //////////////////////////////////////////////

    public void DumpSynths (object slotModule, int slots, string synth, boolean createNdl)
    {
        string devpath = noahpath + "Devices/";

        for (int i = 0; i < count (synths); i += 4) {
            if (synth != "" && synth != synths [i])
                continue;
                
            string devname  = devpath  + synths [i] + "/" + synths [i] + ".dev";
            string noahname = noahpath + "Devices/" + synths [i + 1] + "/" + synths [i + 1];
            int voices = atoi (substr (synths [i + 2], 3 * (slots - 1), 3));

            if (voices != 0)
                LoadnDump (slotModule, devname, noahname, voices, createNdl);
        }
    }

    public void DumpInserts (object slotModule)
    {
        string devpath = noahpath + "Effects/";

        string inserts [] = {
            "SSB Phaser",               "SSB Phaser",               
            "2 Voice Pitch Shifter",    "2 Voice Pitch Shifter",    
            "Amplifier",                "Amplifier",                
            "Auto Wah",                 "Auto Wah",                 
            "Autopan",                  "Autopan",                  
            "Compressor",               "Compressor",               
            "Decimator",                "Decimator",                
            "Distortion",               "Distortion",               
            "Dynamics",                 "Dynamics",
            "Ensemble",                 "Ensemble",                 
            "Expander",                 "Expander",                 
            "Feedback Pitch Shifter",   "Feedback Pitch Shifter",   
            "Gate",                     "Gate",                     
            "Graphic EQ",               "Graphic EQ",               
            "Harmonic Chorus",          "Harmonic Chorus",          
            "Harmonic Flanger",         "Harmonic Flanger",         
            "Hexa Chorus",              "Hexa Chorus",              
            // "Lesslie",                  "Lesslie",                  
            "Limiter",                  "Limiter",                  
            "Master Chorus",            "Master Chorus",            
            "Master Flanger",           "Master Flanger",           
            "Master Phaser",            "Master Phaser",            
            "Overdrive",                "Overdrive",                
            "Parametric EQ",            "Parametric EQ",            
            "Random Flanger",           "Random Flanger",           
            "Resonator",                "Resonator",                
            "Ringmodulator",            "Ringmodulator",            
            "Softclip",                 "Softclip",                 
            "Space Flanger",            "Space Flanger",            
            "Step Flanger",             "Step Flanger",             
            "Stereo EQ",                "Stereo EQ",                
            "Stereo Expander",          "Stereo Expander",          
            "Stereo Pitch Shifter",     "Stereo Pitch Shifter",     
            "Tremolo",                  "Tremolo",                  
            "Triple Chorus",            "Triple Chorus",            
            "Tube Processor",           "Tube Processor",           
        };

        for (int i = 0; i < count (inserts); i += 2) {
            string devname  = devpath  + inserts [i] + "/" + inserts [i] + ".dev";
            string noahname = noahpath + "Effects/" + inserts [i + 1] + "/" + inserts [i + 1];
            int voices = -1;

            LoadnDump (slotModule, devname, noahname, voices, true);
        }
    }

    public void DumpDelays (object slotModule)
    {
        string devpath = noahpath + "Delays/";

        string delays [] = {
            "Dual Delay",     "Dual Delay",     
            "LCR Delay",      "LCR Delay",      
            "Multitap Delay", "Multitap Delay", 
            "Stereo Delay",   "Stereo Delay",   
            "Synth Delay",    "Synth Delay",    
        };

        for (int i = 0; i < count (delays); i += 2) {
            string devname  = devpath  + delays [i] + "/" + delays [i] + ".dev";
            string noahname = noahpath + "Delays/" + delays [i + 1] + "/" + delays [i + 1];
            int voices = -1;

            LoadnDump (slotModule, devname, noahname, voices, true);
        }
    }

    //////////////////////////////////////////////

    public void WaitForLock ()
    {
      #if 1
        int n1, n2;
        boolean caching, hadError, panicking, megapanicking;
        
        for (int i = 0; i < 100; i++)
            SApp.HardwareConfigModule().OnTimer (0);
        
        int tm = GetSystemTime (10);
        while (SHardware.HalStatus (n1, n2, caching, hadError, panicking, megapanicking) && (panicking || caching)) {
            if (GetSystemTime (10) > tm + 20000)
                throw "hardware does not lock to current sample rate settings";
            SApp.HardwareConfigModule().OnTimer (0);
        }
        //TRACE (format ("HalStatus(caching=%d, hadError=%d, panicking=%d, megapanicking=%d)", 
        //               caching, hadError, panicking, megapanicking)); ForceGraphicUpdate ();
      #else
        SApp.HardwareConfigModule().SetFreq (44100);
      #endif
    }
    
    public void restartModel (string model)
    {
        string config = SIni.GetString ("hw", "defconfig", "hw");

        string board = "namex1-sram";
        if (replace (makeupper (model), "NOAHX", "") == makeupper (model))
            board = "name1-sram";

        object hw = SApp.GetModule().ChildByClass("HardWareInfo",0,-1);
        if(hw!=nil)
            hw.VarByName("Show").ValueCallSend(0); // be sure no bench module is loaded!
        SApp.HardwareConfigModule().Reset();

        SIni.SetString (config, "board0", board);
        SIni.SetString (config, "slotmodel", model);
        SIni.Close ();
            
        SSystem.RelaunchSim(config);
            
        SApp.HardwareConfigModule().Update();

        WaitForLock ();
    }

    public void DumpSlotModels (boolean extended)
    {
        string config = SIni.GetString ("hw", "defconfig", "hw");
        string board0 = SIni.GetString (config, "board0", "board0");
        string model  = SIni.GetString (config, "slotmodel", "");
        
        string modelnames [], base, board;
        if (!extended) {
            string models [] = { "AA", "B" };
            modelnames = models;
            base = "Noah-Model-";
            board = replace (board0, "namex1", "name1");
        } else {
            string models [] = { "AAAA", "AAB", "ABA", "BAA", "BB", "AC", "CA", "D" };
            modelnames = models;
            base = "NoahX-Model-";
            board = replace (board0, "name1", "namex1");
        }

        object hw = SApp.GetModule().ChildByClass("HardWareInfo",0,-1);
        if(hw!=nil)
            hw.VarByName("Show").ValueCallSend(0); // be sure no bench module is loaded!
        SApp.HardwareConfigModule().Reset();

        SIni.SetString (config, "board0", board);

        for (int i = 0; i < count (modelnames); i++) {
            SIni.SetString (config, "slotmodel", base + modelnames [i]);
            SIni.Close ();
            
            SSystem.RelaunchSim(config);
            // relaunchsim ();
            
            TRACE ("writing " + noahpath + "Models/model-" + modelnames [i] + ".nsm"); ForceGraphicUpdate ();
            if (!SSystem.DumpDSPSlotModel (noahpath + "Models/model-" + modelnames [i] + ".nsm"))
                throw "dumping " + base + modelnames [i] + " failed";
        }

        string kernelFile = noahpath + "Models/noah" + (extended ? "X" : "") + ".nkl";
        if (true || !SFile.Exists (kernelFile)) {
            TRACE ("writing " + kernelFile); ForceGraphicUpdate ();
            if (!SSystem.DumpDSPKernelLib (kernelFile))
                throw "DumpDSPKernelLib (" + kernelFile + ") failed";
        }

        SIni.SetString (config, "board0", board0);
        SIni.SetString (config, "slotmodel", model);
        SSystem.RelaunchSim(config);
        SApp.HardwareConfigModule().Update();
    }

    //////////////////////////////////////////////

    public void DumpMixer (object mixerslot, boolean dump)
    {
        object mixer = mixerslot.LoadChild (noahpath + "Mixer/Mixer.dev", true, true);
        if (mixer == nil)
            throw "cannot load mixer";
        mixer.SetPersistent (0);
        
        object aux = mixerslot.LoadChild (noahpath + "Tools/Aux FX/Aux FX.dev", true, true);
        if (aux == nil)
            throw "cannot load Aux FX";
        aux.SetPersistent (0);
        
        mixerslot.ChildByName ("ParallelBus Device1").PadByName ("Out0").ConnectVisible (mixer.PadByName ("InL1"));
        mixerslot.ChildByName ("ParallelBus Device1").PadByName ("Out1").ConnectVisible (mixer.PadByName ("InR1"));
        
        mixerslot.ChildByName ("ParallelBus Device2").PadByName ("Out0").ConnectVisible (mixer.PadByName ("InL2"));
        mixerslot.ChildByName ("ParallelBus Device2").PadByName ("Out1").ConnectVisible (mixer.PadByName ("InR2"));

        mixerslot.ChildByName ("ParallelBus Device3").PadByName ("Out0").ConnectVisible (mixer.PadByName ("InL3"));
        mixerslot.ChildByName ("ParallelBus Device3").PadByName ("Out1").ConnectVisible (mixer.PadByName ("InR3"));

        mixerslot.ChildByName ("ParallelBus Device4").PadByName ("Out0").ConnectVisible (mixer.PadByName ("InL4"));
        mixerslot.ChildByName ("ParallelBus Device4").PadByName ("Out1").ConnectVisible (mixer.PadByName ("InR4"));

        mixerslot.ChildByName ("ParallelBus Host").PadByName ("Out0").ConnectVisible (mixer.PadByName ("InL5"));
        mixerslot.ChildByName ("ParallelBus Host").PadByName ("Out1").ConnectVisible (mixer.PadByName ("InR5"));

        mixerslot.ChildByName ("ParallelBus Host").PadByName ("Out2").ConnectVisible (mixer.PadByName ("InL6"));
        mixerslot.ChildByName ("ParallelBus Host").PadByName ("Out3").ConnectVisible (mixer.PadByName ("InR6"));

        if (mixerslot.ChildByName ("SPDIF Subcode Filter") != nil) {
            mixer.PadByName ("AD1").ConnectVisible (mixerslot.ChildByName ("SPDIF Subcode Filter").PadByName ("inL"));
            mixer.PadByName ("AD2").ConnectVisible (mixerslot.ChildByName ("SPDIF Subcode Filter").PadByName ("inR"));
        } else {
            mixer.PadByName ("AD1").ConnectVisible (mixerslot.ChildByName ("PBus MixOut").PadByName ("AD1"));
            mixer.PadByName ("AD2").ConnectVisible (mixerslot.ChildByName ("PBus MixOut").PadByName ("AD2"));
        }
        mixer.PadByName ("AD3").ConnectVisible (mixerslot.ChildByName ("PBus MixOut").PadByName ("AD3"));
        mixer.PadByName ("AD4").ConnectVisible (mixerslot.ChildByName ("PBus MixOut").PadByName ("AD4"));
        mixer.PadByName ("AD5").ConnectVisible (mixerslot.ChildByName ("PBus MixOut").PadByName ("AD5"));
        mixer.PadByName ("AD6").ConnectVisible (mixerslot.ChildByName ("PBus MixOut").PadByName ("AD6"));
        mixer.PadByName ("AD7").ConnectVisible (mixerslot.ChildByName ("PBus MixOut").PadByName ("AD7"));
        mixer.PadByName ("AD8").ConnectVisible (mixerslot.ChildByName ("PBus MixOut").PadByName ("AD8"));

        mixer.PadByName ("AnL").ConnectVisible (mixerslot.ChildByName ("PBus MixOut").PadByName ("AnL"));
        mixer.PadByName ("AnR").ConnectVisible (mixerslot.ChildByName ("PBus MixOut").PadByName ("AnR"));

        mixer.PadByName ("USB1").ConnectVisible (mixerslot.ChildByName ("PBus MixOut").PadByName ("USB1"));
        mixer.PadByName ("USB2").ConnectVisible (mixerslot.ChildByName ("PBus MixOut").PadByName ("USB2"));
        mixer.PadByName ("USB3").ConnectVisible (mixerslot.ChildByName ("PBus MixOut").PadByName ("USB3"));
        mixer.PadByName ("USB4").ConnectVisible (mixerslot.ChildByName ("PBus MixOut").PadByName ("USB4"));
        mixer.PadByName ("USB5").ConnectVisible (mixerslot.ChildByName ("PBus MixOut").PadByName ("USB5"));
        mixer.PadByName ("USB6").ConnectVisible (mixerslot.ChildByName ("PBus MixOut").PadByName ("USB6"));

        mixer.PadByName ("DL1").ConnectVisible (mixerslot.ChildByName ("PBus MixOut").PadByName ("DL1"));
        mixer.PadByName ("DR1").ConnectVisible (mixerslot.ChildByName ("PBus MixOut").PadByName ("DR1"));
        mixer.PadByName ("DL2").ConnectVisible (mixerslot.ChildByName ("PBus MixOut").PadByName ("DL2"));
        mixer.PadByName ("DR2").ConnectVisible (mixerslot.ChildByName ("PBus MixOut").PadByName ("DR2"));
        mixer.PadByName ("DL3").ConnectVisible (mixerslot.ChildByName ("PBus MixOut").PadByName ("DL3"));
        mixer.PadByName ("DR3").ConnectVisible (mixerslot.ChildByName ("PBus MixOut").PadByName ("DR3"));
        mixer.PadByName ("DL4").ConnectVisible (mixerslot.ChildByName ("PBus MixOut").PadByName ("DL4"));
        mixer.PadByName ("DR4").ConnectVisible (mixerslot.ChildByName ("PBus MixOut").PadByName ("DR4"));
        mixer.PadByName ("DL5").ConnectVisible (mixerslot.ChildByName ("PBus MixOut").PadByName ("DL5"));
        mixer.PadByName ("DR5").ConnectVisible (mixerslot.ChildByName ("PBus MixOut").PadByName ("DR5"));
        mixer.PadByName ("DL6").ConnectVisible (mixerslot.ChildByName ("PBus MixOut").PadByName ("DL6"));
        mixer.PadByName ("DR6").ConnectVisible (mixerslot.ChildByName ("PBus MixOut").PadByName ("DR6"));

        mixer.PadByName ("sdL1").ConnectVisible (mixerslot.ChildByName ("MBus Insert1Send").PadByName ("In1L"));
        mixer.PadByName ("sdR1").ConnectVisible (mixerslot.ChildByName ("MBus Insert1Send").PadByName ("In1R"));
        mixer.PadByName ("sdL2").ConnectVisible (mixerslot.ChildByName ("MBus Insert1Send").PadByName ("In2L"));
        mixer.PadByName ("sdR2").ConnectVisible (mixerslot.ChildByName ("MBus Insert1Send").PadByName ("In2R"));
        
        mixerslot.ChildByName ("MBus Insert1Ret").PadByName ("In1L").ConnectVisible (mixer.PadByName ("rtL1"));
        mixerslot.ChildByName ("MBus Insert1Ret").PadByName ("In1R").ConnectVisible (mixer.PadByName ("rtR1"));
        mixerslot.ChildByName ("MBus Insert1Ret").PadByName ("In2L").ConnectVisible (mixer.PadByName ("rtL2"));
        mixerslot.ChildByName ("MBus Insert1Ret").PadByName ("In2R").ConnectVisible (mixer.PadByName ("rtR2"));
        
        mixerslot.ChildByName ("MBus Insert1Ret").PadByName ("DelL").ConnectVisible (aux.PadByName ("DrL"));
        mixerslot.ChildByName ("MBus Insert1Ret").PadByName ("DelR").ConnectVisible (aux.PadByName ("DrR"));
        
        mixerslot.ChildByName ("MBus Insert1Send").PadByName ("DelL").ConnectVisible (aux.PadByName ("DsL"));
        mixerslot.ChildByName ("MBus Insert1Send").PadByName ("DelR").ConnectVisible (aux.PadByName ("DsR"));
        
        mixer.PadByName ("axL1").ConnectVisible (aux.PadByName ("InL1"));
        mixer.PadByName ("axR1").ConnectVisible (aux.PadByName ("InR1"));
        mixer.PadByName ("axL2").ConnectVisible (aux.PadByName ("InL2"));
        mixer.PadByName ("axR2").ConnectVisible (aux.PadByName ("InR2"));
        mixer.PadByName ("axL3").ConnectVisible (aux.PadByName ("InL3"));
        mixer.PadByName ("axR3").ConnectVisible (aux.PadByName ("InR3"));
        
        mixer.PadByName ("RtL1").ConnectVisible (aux.PadByName ("RtL1"));
        mixer.PadByName ("RtR1").ConnectVisible (aux.PadByName ("RtR1"));
        mixer.PadByName ("RtL2").ConnectVisible (aux.PadByName ("RtL2"));
        mixer.PadByName ("RtR2").ConnectVisible (aux.PadByName ("RtR2"));
        mixer.PadByName ("RtL3").ConnectVisible (aux.PadByName ("RtL3"));
        mixer.PadByName ("RtR3").ConnectVisible (aux.PadByName ("RtR3"));

        if (dump)
            CreateSlotDump (mixer, noahpath + "Mixer/Mixer", -1, true);
    }

    //////////////////////////////////////////////

    public void LoadnDumpSynths (int slots, string slotdevname, string synth, boolean createNdl)
    {
        object app = SApp.GetModule();
        if (!app.LoadProject (noahproject))
            return;
        WaitForLock ();
        
        object proj = app.Project;
        object devslot = proj.LoadChild (slotdevname);
        if (devslot == nil)
            throw "cannot load deviceslot " + slotdevname;
        DumpSynths (devslot, slots, synth, createNdl);

        if (deleteDev)
            DeleteObject (proj);
    }
        
    //////////////////////////////////////////////

    public void RestartAndDumpAllSynths (string model, int slots, string slotmodule, boolean createNdl, string synth)
    {
        for (int i = 0; i < count (synths); i += 4) {
            if (synth != "" && synths [i] != synth)
                continue;
                
            int convrt  = atoi (substr (synths [i + 3], 3 * (slots - 1), 3));
            int b2nslot = (convrt == 0 ? -1 : 5);
            
            SIni.SetInt ("namex-DSP1", "bridge2nixMin", convrt);
            SIni.SetInt ("namex-DSP2", "bridge2nixMin", convrt);
            SIni.SetInt ("namex-DSP3", "bridge2nixMin", convrt);
            SIni.SetInt ("namex-DSP4", "bridge2nixMin", convrt);
            SIni.SetInt ("namex-DSP5", "bridge2nixMin", convrt);
            
            SIni.SetInt ("namex-DSP1", "bridge2nixSlot", b2nslot);
            SIni.SetInt ("namex-DSP2", "bridge2nixSlot", b2nslot);
            SIni.SetInt ("namex-DSP3", "bridge2nixSlot", b2nslot);
            SIni.SetInt ("namex-DSP4", "bridge2nixSlot", b2nslot);
            SIni.SetInt ("namex-DSP5", "bridge2nixSlot", b2nslot);
            
            restartModel (model);
            LoadnDumpSynths (slots, slotmodule, synths [i], createNdl);
        }
    }
      
    public void DumpAll (boolean dumpMixer, boolean dumpDelays, 
                         boolean dumpInserts, int synthModels)
    {
        string config = SIni.GetString ("hw", "defconfig", "hw");
        string model  = SIni.GetString (config, "slotmodel", "");
        
        object app = SApp.GetModule();
        if (!app.DeleteProject())
            return;
        
        int n1, n2;
        boolean caching, hadError, panicking, megapanicking;
        while (SHardware.HalStatus (n1, n2, caching, hadError, panicking, megapanicking) && caching) {
            TRACE ("lowering hal caching status");
            RunStopDSP (true);
        }

        if (false) {
            DumpSlotModels (false);
//            DumpSlotModels (true);
            return;
        }
        
        if (dumpMixer || dumpDelays || dumpInserts) {
            restartModel ("NoahX-Model-AAAA");
    
            if (!app.LoadProject (noahproject))
                return;
            WaitForLock ();
            
            object proj = app.Project;
            if (dumpMixer)
                DumpMixer (proj.MixerSlot, true);
            if (dumpDelays)
                DumpDelays (proj.DelaySlot);
            if (dumpInserts)
                DumpInserts (proj.Insert1Slot);

            DeleteObject (proj);
        }    

        string synth = EditSynth;
        if (synth == "All Synth")
            synth = "";

        // start with extended model, so we have 2nix64 converters in the module lib
        if ((synthModels & 8) != 0) {
            RestartAndDumpAllSynths ("NoahX-Model-D", 4, noahslotpath + "DeviceSlotD.mdl", true, synth);
        }
      
        if ((synthModels & 2) != 0) {
            RestartAndDumpAllSynths ("NoahX-Model-BAA", 2, noahslotpath + "DeviceSlotB.mdl", false, synth);
        }
      
        if ((synthModels & 1) != 0) {
            RestartAndDumpAllSynths ("NoahX-Model-AAAA", 1, noahslotpath + "DeviceSlotA.mdl", false, synth);
        }

        if ((synthModels & 4) != 0) {
            RestartAndDumpAllSynths ("NoahX-Model-CA", 3, noahslotpath + "DeviceSlotC.mdl", false, synth);
        }

        if (deleteDev)      
            restartModel (model);
  }

    public void OnDmpCyclesChanged () {

         SApp.HardwareConfigModule ().PepGetChildByClass ("PepAtom").DoTest (1);
         if (MessageBox("DumpFile on c:/cycles.dmp. Edit?","DumpCycles", MB_YESNO) == IDYES)
            SFile.Edit("c:/cycles.dmp", false, "notepad.exe");
            
    }

    public void OnDmpSlotAChanged () {
        DumpAll (false, false, false, 1);
    }
    public void OnDmpSlotBChanged () {
        DumpAll (false, false, false, 2);
    }
    public void OnDmpSlotCChanged () {
        DumpAll (false, false, false, 4);
    }
    public void OnDmpSlotDChanged () {
        DumpAll (false, false, false, 8);
    }
    public void OnDmpAllChanged () {
        DumpAll (false, false, false, 0xf);
    }
    public void OnDmpMixerChanged () {
        DumpAll (true, false, false, 0);
    }
    public void OnDmpDelaysChanged () {
        DumpAll (false, true, false, 0);
    }
    public void OnDmpEffectsChanged () {
        DumpAll (false, false, true, 0);
    }
}
