#include "Scope.ped"

class App@Scope@ModuleParameters extends App@Scope@CaptionSurface
{
	public object	SelObject;
	public object   SelParameter;

	boolean  _freeze = false;
	object	 _tree;
	object	 _list;
	object	 _ranger;

	object   _module;
	object   _caption;

	object   _selparameter;
	object	 _menuFreeze;	

	object   _copiedModule;

#define MCMD_WRITEUUIDS			50
#define MCMD_READUUIDS			51
#define MCMD_CREATEFROMUUIDS	52
#define MCMD_FREEZE				53
#define MCMD_RECALCUUIDS		54

	public object AddToViewTree(object pvi, int vid) {
		object vi = super.AddToViewTree(pvi, vid);
		vi.GetGO().UpdateAlignment();
		OnSelObjectChanged();
		return vi;
	}

	public void Update() {
		enableCaption( false );
		_tree = ChildByClass("App@Scope@ModuleParameterTree",0,-1);
		_list = ChildByClass("App@Scope@ModuleParameterList",0,-1);
		_ranger = ChildByClass("ParameterRanger",0,-1);
		super.Update();
	}

	public void OnObjectDeleted(object obj) {
		_freeze = false;
		SelObject=nil;
		OnSelObjectChanged();
		_menuFreeze.ShowText(_freeze ? 1 : 0);
	}

	void updateViews() {
		_tree.FillTree(_module);
		_list.FillList(_module);
	}

	public void OnSelObjectChanged() {
		object lastmdl = _module;

		if(_freeze)  {
			if(_module==nil)
				OnObjectDeleted(nil);
			return;
		}

		if(SelObject==nil || SelObject.isModule()) {
			if(_module!=nil)
				_module.RemoveFromModuleDeleteCB( this );
			_module = SelObject;
			if(_module!=nil)
				_module.AddToModuleDeleteCB( this );
		}

		if(TopVI()==nil) 
			return;

		boolean autop = pasteEnabled() && _module != lastmdl && autoPaste()>0;
		if(autop) {
			RecallSettings();
			if(autoPaste()==1)
				setAutoPaste( 0 );
		}


		_caption.SetText( _module==nil ? "<No Parameters available>" : "Parameters of "+_module.Name() );

		_list.VarByName("SortColumn").ValueSend( -1 );
		updateViews();

		enableCaption( _module!=nil );
	}

	public void MenuCBOnRecalcMenu(object menu) {
		menu.RemoveAll();

		_caption = menu.AddItem(Name(), "Caption", 0);

		menu.RecalcChildItems(1,-1);
		
		_menuFreeze = menu.AddItem("Freeze", MENU_TEXTBUTTON, MCMD_FREEZE);

		createMenuCopy( menu );
		createMenuAutoPaste( menu );
		createMenuPaste( menu );

		object o = menu.AddItem("", MENU_EXTENDED, MCMD_EXTENDED);
		o.AddItem("Write UUID file ...", MENU_NORMAL, MCMD_WRITEUUIDS);
		o.AddItem("Read UUID file ...", MENU_NORMAL, MCMD_READUUIDS);
		o.AddItem("Create from UUID file ...", MENU_NORMAL, MCMD_CREATEFROMUUIDS);
		o.AddItem("Assign new UUIDs...", MENU_NORMAL, MCMD_RECALCUUIDS);

		o.RecalcChildItems();

		menu.AddItem("", "Close", 5);

		recalcMenuAppearance();

		enableCaption(true);
	}

	public void MenuCBOnSelectItem(object menu, object item) {
		int id = item.GetDefaultData();
		switch(id) {
		case MCMD_FREEZE:
				_freeze=!_freeze;
				_menuFreeze.ShowText(_freeze ? 1 : 0);
				OnSelObjectChanged();
				break;
			case MCMD_READUUIDS			: readUUIDs(false); _list.FillList(_module); break;
			case MCMD_CREATEFROMUUIDS	: readUUIDs(true); _list.FillList(_module); break;
			case MCMD_WRITEUUIDS		: writeUUIDs(); break;
			case MCMD_RECALCUUIDS		: assignUUIDs(); break;
			default						: super.MenuCBOnSelectItem(menu, item); break;
		}
	}

	void assignUUIDs() {
		int i, n = _module.ParameterCount();
		for(i=0;i<n;i++) {
			object parameter = _module.ParameterByIndex(i);
			parameter.UniqueID(SSystem.CreateUUIDString());
		}
	}

	void writeUUIDs() {
		if(SApp.FileDialog().OpenSaveTextDump(_module.Name()+" UUIds")) {
			string path = SApp.FileDialog().SelectedString;
			SFile.Delete(path);
			int cnt = _module.ParameterCount();
			int totSize = 0;
			int totplSize = 0;
			for(int i=cnt-1;i>=0;i--) {
				object parameter = _module.ParameterByIndex(i);
				string mdlname = parameter.GetVar()!=nil ? parameter.GetVar().GetModule().Name() : format("Unresolved%d",i);
				SIni.SetString( "ParameterUniqeIDs", 
								format("%d. ", i+1)+mdlname+"::"+parameter.Name(),
								parameter.UniqueID(), 
								path);

				SIni.SetInt( "ParameterFlags", 
								format("%d. ", i+1)+mdlname+"::"+parameter.Name(),
								parameter.Flags(), 
								path);

				if(parameter.GetVar()!=nil) {
					SIni.SetInt( "ParameterSizes", 
									format("%d. ", i+1)+mdlname+"::"+parameter.Name(),
									parameter.GetVar().DataSize(), 
									path);
					totSize+=parameter.GetVar().DataSize();

					if(parameter.restoreInPreset())
						totplSize+=parameter.GetVar().DataSize();
				}
			}
			SIni.SetInt( "Statistics", 
							"Total parameter size (byte)",
							totSize, 
							path);

			SIni.SetInt( "Statistics", 
							"Total parameter size (byte)",
							totSize, 
							path);
			SIni.SetInt( "Statistics", 
							"Total preset parameter size (byte)",
							totplSize, 
							path);

			SIni.Close(path);
		}
	}

	void readUUIDs(boolean create) {
		if(SApp.FileDialog().OpenLoadTextDump(_module.Name()+" UUIds")) {
			string path = SApp.FileDialog().SelectedString;
			string	entries[] = SIni.GetSection( "ParameterUniqeIDs", path );
			int		cnt = count( entries );
			object	par;
			for(int i=0;i<cnt;i++) {
				int		n = find(entries[i], ".");
				string  paramname = substr(entries[i], n+1, strlen(entries[i]));
				n = find(paramname, "::");					
				string mod = substr(paramname, 0, n);
				paramname = substr(paramname, n+2, strlen(paramname));
				for(int ii=0;  (par = _module.ParameterByName(paramname, ii))!=nil && 
								(par.GetVar() == nil || par.GetVar().GetModule().Name()!=mod); ii++);

				if(create && par==nil)
					par = _module.ParameterByUUID(SIni.GetString( "ParameterUniqeIDs", entries[i],"", path));

				if(create && par==nil) {
					object v = _module.ChildByName(mod);
					if(v!=nil) 
						v = v.VarByName(str);

					par = _module.CreateParameter( v );
					par.Name( paramname );
				}

				if(par!=nil) {
					par.UniqueID( SIni.GetString( "ParameterUniqeIDs", 
									entries[i],
									par.UniqueID(), 
									path));

					par.Flags( SIni.GetInt( "ParameterFlags", 
									entries[i],
									par.Flags(), 
									path));
				}
			}
			SIni.Close(path);
		}
	}

	public void ParameterSelectionChanged( object sender, object parameter ) 
	{		
		if(_list!=sender)
			_list.SelectParameter(parameter);
		if(_tree!=sender)
			_tree.SelectParameter(parameter);
		if(_ranger!=sender)
			_ranger.SelectParameter(parameter);

		VarByName("SelParameter").ValueSend( parameter );
	}

	protected boolean	isContentValid() { return _module!=nil; }
	protected boolean	StoreSettings()  { _copiedModule = _module; return true; }
	protected boolean	RecallSettings() { 
		if(_copiedModule==nil) return false; 

		int i, n = _copiedModule.ParameterCount();
		for(i=0; i<n; i++) {
			object parameter = _copiedModule.ParameterByIndex(i);
			object mdlparameter = _module.ParameterByUUID( parameter.UniqueID() );
			object var;
			if(mdlparameter!=nil) {
				var = mdlparameter.GetVar();
				DeleteObject( mdlparameter );
			} else if(parameter.GetVar()!=nil) {
				var = parameter.GetVar();
				if(var.GetModule()!=_module && !var.GetModule().IsChildOf(_module))
					var = nil;
			}

			mdlparameter = _module.CreateParameter( var );
			mdlparameter.CopyFrom( parameter );
		}

		return true;
	}
}