#include "../../Controls/ListCtrl.ped"
#include "../../MessageBox.ped"

class App@SCOPE@HWUnitSelector extends Controls@BasicListCtrl {

	static {
		InitList();
	}

	public void Update() {
		InitList();
	}

	void InitList() {
		object go = ListCtrl();
		object goHead = ListCtrlHead();

		go.RemoveAllColumns();
		go.RemoveAllRows();

		go.SetItemTemplate(GOByName("TSelection"), LISTCTRL_IT_ICON, 1);
		go.AddColumn(80, 1).SetItemTemplate(GOByName("TTCard"), LISTCTRL_IT_VALUE);
		go.AddColumn(80, 2).SetItemTemplate(GOByName("TTCard"), LISTCTRL_IT_VALUE);
		go.AddColumn(20, 3).SetItemTemplate(GOByName("TTConnected"), LISTCTRL_IT_ICON);
		go.AddColumn(100, 4).SetItemTemplate(GOByName("TTSyncSource"), LISTCTRL_IT_VALUE);
		go.AddColumn(120, 5).SetItemTemplate(GOByName("TTSyncSource"), LISTCTRL_IT_VALUE);;

		go.AddRow(14);
		go.DataTable().DeleteAll();

		goHead.SetItemTemplate(GOByName("TTHead"), LISTCTRL_IT_VALUE);

		goHead.RemoveAllColumns();
		goHead.RemoveAllRows();

		goHead.AddColumn(100, 0);
		goHead.AddColumn(100, 1);
		goHead.AddColumn(20, 2);
		goHead.AddColumn(100, 3);
		goHead.AddColumn(120, 4);
		goHead.AddRow(16, 0);
		goHead.DataTable().DeleteAll();
		object ds = goHead.DataTable().AddDataSet();
		ds.DataCount(5);
		ds.SetDataByIndex(0, "Card");
		ds.SetDataByIndex(1, "Plate");
		ds.SetDataByIndex(2, "Connected");
		ds.SetDataByIndex(3, "IO");
		ds.SetDataByIndex(4, "Type");
		
		object cm = SApp.Project().ChildByClass("Hardware@ConfigurationManager",0,-1);
		int i, n = cm.ChildCount();
		BoardNames = new string[n];
		for(i=0; i<n; i++) {
			object card = cm.ChildByIndex(i);
			object ds = go.DataTable().AddDataSet();
			ds.AddData(i);			
			ds.AddData(card.Name());
			ds.AddData("");
			ds.AddData(-1);
			ds.AddData("");
			ds.AddData("");

			BoardNames[i] = card.Name();

			object p = card.Plate();
			int ii, nn = p!=nil ? p.SyncSourceCount() : 0;
			for(ii = 0; ii<nn; ii++) {
				object ds = go.DataTable().AddDataSet();
				ds.AddData(i);			
				ds.AddData("");
				ds.AddData(card.PlateName());
				ds.AddData(p.SyncSourceStatus(ii));
				ds.AddData(p.SyncSourceName(ii));
				ds.AddData(p.SyncSourceTypeName(ii));
			}
		}
		FitListCtrlSize();
		VarByName("BoardNames").Send();
	}

	public int OnKeyDown( object event ) 
	{
		InitList();
		return 1;
	}

	public void OnMainCardChanged() {
		object cm = SApp.Project().ChildByClass("Hardware@ConfigurationManager",0,-1);
		object card = cm.ChildByIndex(MainCard);
		object p = card.Plate();
		int ii, nn = p!=nil ? p.SyncSourceCount() : 0;
		SyncSourceNames = new string [nn];
		for(ii = 0; ii<nn; ii++)
			SyncSourceNames[ii] = p.SyncSourceName(ii);
		VarByName("SyncSourceNames").Send();
		object cm = SApp.Project().ChildByClass("Hardware@ConfigurationManager",0,-1);
		cm.VarByName("BoardMaster").Value(MainCard);
		cm.VarByName("WorldMaster").ValueCall(WorldMaster==0 ? -1 : MainCard);	
	}

	public void OnSyncSourceChanged() 
	{
		object cm = SApp.Project().ChildByClass("Hardware@ConfigurationManager",0,-1);
		object card = cm.ChildByIndex(MainCard);
		object p = card.Plate();
		p.SetSyncSource(SyncSource);
	}

	public void OnSampleRateChanged() {		
		object cm = SApp.Project().ChildByClass("Hardware@ConfigurationManager",0,-1);
		cm.VarByName("SampleRate").ValueCall(SampleRate);
		object hw = SApp.HardwareConfigModule();		
	}

	public void OnWorldMasterChanged() {
		object cm = SApp.Project().ChildByClass("Hardware@ConfigurationManager",0,-1);
		cm.VarByName("WorldMaster").ValueCall(WorldMaster==0 ? -1 : MainCard);
	}
}
