#include "../../Controls/ListCtrl.ped"
#include "../../MessageBox.ped"
#include "../../keycodes.ped"

class App@SCOPE@HWList extends Controls@BasicListCtrl {

#define COL_SYNC 1
#define COL_TYPE 4

	public int WorldMaster;
	public int BoardType;

	public int WriteNoahOS;
	public int WriteNoahPerformance;
	
	public int UpdateConfig;

	object _cm;

	int _selBoard=-1;

	static {		
		InitList();
		if(SApp.HardwareConfigModule()!=nil)
			DeleteObject(SApp.HardwareConfigModule());
	}

	public void Update() {
		InitList();
	}

	public void OnUpdateConfigChanged() {
		object go = ListCtrl();
		object goHead = ListCtrlHead();

		go.RemoveAllColumns();
		go.RemoveAllRows();

		go.SetItemTemplate(GOByName("TSelection"), LISTCTRL_IT_ICON, 1);
		go.AddColumn(60, 0).SetItemTemplate(GOByName("TTCard"), LISTCTRL_IT_VALUE);
		go.AddColumn(16, COL_SYNC).SetItemTemplate(GOByName("TTConnected"), LISTCTRL_IT_ICON);
		go.AddColumn(16, 2).SetItemTemplate(GOByName("TTConnected"), LISTCTRL_IT_ICON);
		go.AddColumn(90, 3).SetItemTemplate(GOByName("TTSyncSource"), LISTCTRL_IT_VALUE);
		go.AddColumn(50, 4).SetItemTemplate(GOByName("TTSyncSource"), LISTCTRL_IT_VALUE);;

		go.AddRow(14);
		go.DataTable().DeleteAll();

		goHead.SetItemTemplate(GOByName("TTHead"), LISTCTRL_IT_VALUE);

		goHead.RemoveAllColumns();
		goHead.RemoveAllRows();

		goHead.AddColumn(60, 0);
		goHead.AddColumn(16, COL_SYNC);
		goHead.AddColumn(16, 2);
		goHead.AddColumn(90, 3);
		goHead.AddColumn(50, 4);
		goHead.AddRow(16, 0);
		goHead.DataTable().DeleteAll();
		object ds = goHead.DataTable().AddDataSet();
		ds.DataCount(5);
		ds.SetDataByIndex(0, "Card/Plate");
		ds.SetDataByIndex(COL_SYNC, "Sync");
		ds.SetDataByIndex(2, "Connected");
		ds.SetDataByIndex(3, "IO");
		ds.SetDataByIndex(4, "Type");
		
		int i, n = _cm.ChildCount();
		for(i=0; i<n; i++) {
			object card = _cm.ChildByIndex(i);
			object ds = go.DataTable().AddDataSet();
			ds.AddData(card.Name());
			ds.AddData(-1);
			ds.AddData(-1);
			ds.AddData("");
			ds.AddData("");
			ds.AddData(i);
			ds.AddData(-1);
			
			object p = card.Plate();
			int ii, nn = p!=nil ? p.SyncSourceCount() : 0;
			for(ii = 0; ii<nn; ii++) {
				object ds = go.DataTable().AddDataSet();
				ds.AddData("   "+card.PlateName());
				ds.AddData(0);
				ds.AddData(p.SyncSourceStatus(ii));
				ds.AddData(p.SyncSourceName(ii));
				ds.AddData(p.SyncSourceTypeName(ii));
				ds.AddData(i);
				ds.AddData(ii);
			}
		}
		FitListCtrlSize();
	}

	void InitList() {
		_cm = ParentByClass("Surfaces@BasicSurface").Parent().ChildByClass("Hardware@ConfigurationManager");
		if(_cm==nil)
			return;

		VarByName("UpdateConfig").ValueSendCall(1);
	}

	protected void selectColumnHead(int col) {
	}

	protected void selectItem(int row, int col) {
		_selBoard = -1;
		int sindex=-1;
		if(row>=0) {
			ListCtrl().DataTable().DataSetByIndex(row).GetDataByIndex(5, _selBoard);
			ListCtrl().DataTable().DataSetByIndex(row).GetDataByIndex(6, sindex);
			VarByName("BoardType").ValueSend(_cm.ChildByIndex(_selBoard).BoardType());
		} else
			VarByName("BoardType").ValueSend(-1);

		if(col == COL_SYNC && sindex>=0) {
			int sync;
			ListCtrl().GetDataByIndex(row, COL_SYNC, sync);
			if(sync==0) {
				int i,n = ListCtrl().RowCount();
				for(i=0; i<n; i++) {
					ListCtrl().GetDataByIndex(i, COL_SYNC, sync);
					if(sync==1) {
						ListCtrl().SetDataByIndex(i, COL_SYNC, 0);
						ListCtrl().InvalidateItem(i, COL_SYNC);
					}
				}
				ListCtrl().SetDataByIndex(row, COL_SYNC, 1);
				ListCtrl().InvalidateItem(row, COL_SYNC);

				object card = _cm.ChildByIndex(_selBoard);
				object p = card.Plate();
				p.SetSyncSource(sindex);
			}
		} else if(col == COL_TYPE) {
		}
		super.selectItem(row, col);
	}

	public int OnKeyDown( object event ) 
	{
		if(event.Key()==KEY_F5)
			InitList();
		return 1;
	}

	public void OnSampleRateChanged() {		
		_cm.VarByName("SampleRate").ValueCall(SampleRate);
	}

	public void OnWorldMasterChanged() {
		_cm.VarByName("WorldMaster").ValueCall(WorldMaster==0 ? -1 : 0);
	}

	public int OnWriteNoahOSChanged() {
		_cm.ChildByIndex(_selBoard).UpdateAllNoahOS();
	}

	public int OnWriteNoahPerformanceChanged() {
		_cm.ChildByIndex(_selBoard).WriteFile2AllNoahFlash();
	}
}
