#include "../../system.ped"
#include "../../Controls/ListCtrl.ped"
#include "../../keycodes.ped"

class App@SCOPE@DSPModuleList extends Controls@BasicListCtrl {
	public void Update() {
		InitList();
	}

	boolean _dragging = false;
	string _draggingstring;

	void InitList() {
		if(ManuFactID()!=1 || (FamilyID()!=3 && FamilyID()!=4))
			return;

		object go = ListCtrl();
		object goHead = ListCtrlHead();

		go.RemoveAllColumns();
		go.RemoveAllRows();

		go.SetItemTemplate(GOByName("TSelection"), LISTCTRL_IT_ICON, 1);
		go.AddColumn(80, 0).SetItemTemplate(GOByName("TTShortName"), LISTCTRL_IT_VALUE);
		go.AddColumn(200, 1).SetItemTemplate(GOByName("TTLongName"), LISTCTRL_IT_VALUE);

		go.AddRow(14);
		go.DataTable().DeleteAll();

		SSystem.DSPModuleTable(go.DataTable());

		goHead.SetItemTemplate(GOByName("TTHead"), LISTCTRL_IT_VALUE);

		goHead.RemoveAllColumns();
		goHead.RemoveAllRows();

		goHead.AddColumn(80, 0);
		goHead.AddColumn(200, 1);
		goHead.AddRow(16, 0);
		goHead.DataTable().DeleteAll();
		object ds = goHead.DataTable().AddDataSet();
		ds.DataCount(2);
		ds.SetDataByIndex(0, "ShortName");
		ds.SetDataByIndex(1, "LongName");
		
		go.DataTable().Sort(1);
		FitListCtrlSize();
	}

	protected boolean AllowMultipleSelection() { return false; }
	protected boolean AllowEdit(int selRow, int selCol) { return false; }
	protected boolean AllowHoverDisplay() { return !_dragging; }

	public int OnLButtonDown(object event) {
		_dragging = false;
		OnMouseHover(event);
		if(event.VIHit().GetGO()==ListCtrl()) {
			int row = ListCtrl().RowIndexByPosition(event.HitGOPosY());

			if(row>=0) {
				ListCtrl().GetDataByIndex(row, 1, _draggingstring);
				_draggingstring = "cw#DSPModule:" + _draggingstring;
			}
		}
		return super.OnLButtonDown(event);
	}

	public int OnMouseMove(object event) {
		if(event.LDown(true) && event.VIHit().GetGO()==ListCtrl() && _draggingstring!="") {
			if(_dragging)
				return 1;
			_dragging = true;
			SApp.SetDragObject( _draggingstring );
			return 1;		
		} 		

		_dragging = false;
		return super.OnMouseMove(event);
	}

    void ReloadDSPFiles () {
        object hw = SApp.HardwareConfigModule ();
        if (hw != nil && (hw = hw.ChildByClass ("PepAtom")) != nil) {
            int cursor = SApp.Cursor(C_WAIT);
            hw.ReloadDSPFiles (true);
            SApp.Cursor(cursor);
        }

        InitList();
        TopVI().GetGO().Update(true);
    }

	public int OnKeyDown( object event ) {
		if(event.Key() == KEY_F5) {
            ReloadDSPFiles ();
			return 1;
		}
		return 0;
	}

    public int OnQueryContextMenu(object viMe, object viHit) {
        return 1;
    }

	public int OnQueryContextEntry( int nIndex, int nSubIndex, string strText, object viMe, object viHit )
	{
		nIndex++;
		if( nSubIndex == 0 ) {
			switch( nIndex ) {
			case 0: 
                strText = "Reload DSP-Files";
                return 1;
            }
        }
        return 0;
    }

    public void OnContextMenu( int nID, int nSubIndex, object viMe, object viHit )
    {
        if( nSubIndex == 0 ) {
            switch( nID ) {
            case 0:
                ReloadDSPFiles ();
            }
        }
    }

}
