class App@Scope@DPInstallerScript extends App@Installer@InstallerScript {

	public void ConfigureDestination() {
		string inipath = DestBinPath()+"cset.ini";

		SFile.Delete( inipath );
		SFile.Copy( SourceBinPath()+"default.ini", inipath );
		SFile.SetAttributes( inipath, 0x80);

		SIni.SetString("Modules", "modpath", DestAppPath()+"DSP/*", inipath);
		SIni.SetString("FileBrowser", "LastPath", DestPath()+"Devices/", inipath);

		SIni.SetString("ReferenceResolver", "All files_Paths", DestPath()+"Devices/", inipath);
		SIni.SetInt("ReferenceResolver", "All files_AutoUse", 1, inipath);

		SIni.SetString("STATICPATH", "HardwareIos", DestPath()+"Devices/Hardware IOs/", inipath);
		SIni.SetString("STATICPATH", "SoftwareIos", DestPath()+"Devices/Software IOs/", inipath);

		SIni.SetString("PATH", "Projects", DestPath()+"Projects/", inipath);

		SIni.Close(inipath);


		SFile.CreateDir( DestPath() + "/Projects/");
		LogCopiedFile(DestPath() + "/Projects/");


        if( SOS.OS() == 0x0002 ){
			string strGroupPath = SRegistry.GetRegString("HKCU","SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders","Programs");
			strGroupPath = strGroupPath + "\\"+AppName()+"\\";
			SFile.CreateDir(strGroupPath);

			SOS.CreateShortcut(DestExeFilePath(), AppName(), SOS.GetDesktopPath() + AppName(), DestBinPath());
            LogCopiedFile(SOS.GetDesktopPath() + AppName()+".lnk");

            SOS.CreateShortcut(DestExeFilePath(), AppName(), strGroupPath + AppName(), DestBinPath());
			LogCopiedFile(strGroupPath + AppName()+".lnk");
//            SOS.CreateShortcut(DestinationPath + "/App/Bin/UnInstaller", "WDR Cutter", strGroupPath + "UnInstaller", DestinationPath + "/App/Bin");
//            LogCopiedFile(strGroupPath + "UnInstaller.lnk");

		}
		else{
			SOS.CreateShortcut(DestExeFilePath(), AppName(), SOS.GetDesktopPath() + AppName(), DestBinPath());
			LogCopiedFile(SFile.ExtractPath(SOS.GetDesktopPath() + AppName()));
		}
	}

	public string AppName() {
		return "ScopeDP";
	}
}