#include "Scope.ped"

class App@Scope@CaptionSurface extends Surfaces@BasicSurface {

	object _menuActive;
	object _menuCopy;
	object _menuPaste;
	object _menuAutoPaste;

	boolean 	_enablepaste=true;
	int			_autoPaste;

	object _menu;

	public object AddToViewTree(object pvi, int vid) {
		object vi = super.AddToViewTree(pvi, vid);
		TopVI().GetGO().UpdateAlignment();
		return vi;
	}

	protected int autoPaste() { return _autoPaste; }

	protected boolean isContentValid()   { return false; }

	protected void createMenuActive(object menu) {
		_menuActive = menu.AddItem("", MENU_ACTIVE, MCMD_ACTIVE);
	}
	protected void createMenuAutoPaste(object menu) {
		_menuAutoPaste = menu.AddItem("", MENU_AUTOPASTE, MCMD_AUTOPASTE);
	}
	protected void createMenuPaste(object menu) {
		_menuPaste = menu.AddItem("", MENU_PASTE, MCMD_PASTE);
	}
	protected void createMenuCopy(object menu) {
		_menuCopy = menu.AddItem("", MENU_COPY,	MCMD_COPY);
	}

	protected void enablePaste()    { _enablepaste = true; _menuPaste.Enable(true); }
	protected void disablePaste()   { _enablepaste = false; _menuPaste.Enable(false); }
	protected boolean pasteEnabled() { return _enablepaste; }

	protected object Menu() { return _menu; }
	protected object MenuPaste() { return _menuPaste; }
	protected object MenuAutoPaste() { return _menuAutoPaste; }
	protected object MenuActive() { return _menuActive; }

	public void MenuCBOnRecalcMenu(object menu) {
		menu.RemoveAll();

		menu.AddItem(Name(), MENU_CAPTION, MCMD_CAPTION);

		menu.RecalcChildItems(1,-1);

		createMenuActive( menu );
		createMenuCopy( menu );
		createMenuAutoPaste( menu );
		createMenuPaste( menu );
		menu.AddItem("", MENU_CLOSE, MCMD_CLOSE);

		recalcMenuAppearance();
		
		_menuPaste.Enable(_enablepaste);
	}

	public void MenuCBOnSelectItem(object menu, object item) {
		int id = item.GetDefaultData();
		switch(id) {
			case MCMD_COPY		: copy(); break;
			case MCMD_AUTOPASTE	: setAutoPaste(autoPaste()>=2 ? 0 : autoPaste()+1); break;
			case MCMD_PASTE		: paste(); break;
			case MCMD_CLOSE		: VarByName("Show").ValueSendCall(0); break;
		}
	}

	public int OnLButtonDblClk(object event) {
		object mg = _menu.GOByName("MenuGroup");		
		if(mg.HitTest(event.RelHitX(), event.RelHitY())) {
			if(Maximize)
				GetClientAreaGO().Show();
			else
				GetClientAreaGO().Hide();
			VarByName("Maximize").ValueCallSend(!Maximize);
		}
		return 1;
	}

	protected void recalcMenuAppearance() {
		//enable = true;
		if(_menu!=nil) {
			int i, n = _menu.ItemCount();
			int x = 5;
			for(i=n-1; i>0; i--) {
				object o=_menu.ItemByIndex(i);				
				x += o.getRightAlign();
				o.AlignRight(x);
				o.AlignTop(0);
				x += o.getWidth()+o.getLeftAlign();
			}
		}
	}

	protected void enableCA(boolean enable) {
		object ca	= GetClientAreaGO();
		if(ca!=nil) {
			if(enable) {
				ca.Flags((ca.Flags()&~0x24));
			} else {
				ca.Flags((ca.Flags()&~0x20) | 0x04);
			}
		}
	}

	protected void enableCaption(boolean enable) {
		//enable = true;
		if(_menu!=nil) {
			object d	= _menu.GOByName("MenuDisable");
			object e	= _menu.GOByName("MenuEnable");

			if(enable) {
				d.Hide();
				e.Show();
			} else {
				e.Hide();
				d.Show();
			}

			object o;
			for(int i=0; (o=_menu.ItemByIndex(i))!=nil; i++) {
				if(o==_menuPaste)
					_menuPaste.Enable(enable && _enablepaste);
				else if(o.GetDefaultData()!=MCMD_CLOSE)
					o.Enable(enable);
			}
		}
	}

	public boolean WantsMenu() { return true; }

	public void Update() {
		_menu = getMenu();
		if(_menu==nil && WantsMenu()) {
			_menu = createMenu();
			_menu.Persistent(false);
			_menu.SetCBModule(this);
			MenuCBOnRecalcMenu(_menu);
		}

		if(VarByName("Maximize")==nil)
			CreateVarByDefaultValue("Maximize", false).CreatePad();

		VarByName("Maximize").CreatePad(Parent()).Name("Maximize");

		if(VarByName("SizeX")==nil && GOByName("Back")!=nil) {
			CreateVarByDefaultValue("SizeX", 0).CreatePad();
			CreateVarByDefaultValue("SizeY", 0).CreatePad();
			GOByName("Back").GetSize(SizeX, SizeY);
		}

		super.Update();
	}

	protected boolean	StoreSettings()  { return false; }
	protected boolean	RecallSettings() { return false; }

	protected void setAutoPaste(int n) {
		_autoPaste = n;
		if(_autoPaste==1) {
			if(StoreSettings()) 				
				enablePaste();
			else
				disablePaste();
		}
		MenuAutoPaste().ShowIcon(_autoPaste);
	}

	protected void copy() {
		setAutoPaste(0);

		if(StoreSettings())
			enablePaste();
	}

	protected void paste() {
		if(isContentValid())
			RecallSettings();
	}

	protected void maximize(object vi) {  // maximize ist hier eigentlich ein minimize!
		object go = vi.GetGO();	
		int sx, sy, nsx, nsy;
		go.GetSize(sx, sy);
		object mg = _menu.GOByName("MenuGroup");
		mg.GetSize(nsx, nsy);
		vi.GetGO().SetSize(sx, nsy);
		CallChildrenMethod("OnResize",1, 0, nsy-sy);
		RecalcScrollbars();
		RecalcDimension(false, false);
	}

	protected object sizeVI() {
		object o = ResizeBorder();
		if(o==nil)
			o = GOByName("Back");

		return o.GetViewItemByIndex(0);
	}

	public void OnMaximizeChanged() {
		if(Maximize)
			GetClientAreaGO().Hide();
		else
			GetClientAreaGO().Show();

		super.OnMaximizeChanged();
	}

	protected object getMenu() {
		return ChildByClass("Controls@Menu");
	}

	protected object createMenu() {
		return LoadChild("#APPPATH#Dialogs/Caption.mdl");
	}
}
